/*
 * Decompiled with CFR 0.152.
 */
package bird.gui;

import bird.gui.NumericTextField;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IPAddrEditPanel
extends JPanel {
    private NumericTextField[] tfIPFields_;
    public static final int NUM_FIELDS = 4;
    public static final String EMPTY_IP = "000.000.000.000";

    public IPAddrEditPanel() {
        super(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.tfIPFields_ = new NumericTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.tfIPFields_[i] = new NumericTextField("", 3);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(this.tfIPFields_[i], gridBagConstraints);
            this.add(this.tfIPFields_[i]);
            if (i >= 3) continue;
            JLabel jLabel = new JLabel(".");
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
        }
    }

    public String getText() {
        String string = "";
        for (int i = 0; i < 4; ++i) {
            String string2 = this.tfIPFields_[i].getText();
            if (string2 != null && !string2.equals("") && string2.length() <= 3) {
                for (int j = string2.length(); j < 3; ++j) {
                    string2 = "0" + string2;
                }
            } else {
                string2 = "000";
            }
            string = string + string2;
            if (i >= 3) continue;
            string = string + ".";
        }
        return string;
    }

    public void setText(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            String string2;
            n2 = string.indexOf(46, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (!IPAddrEditPanel.isIPStrDivValid(string2 = string.substring(n, n2))) {
                string2 = "0";
            }
            while (string2.length() <= 3 && string2.length() > 1 && string2.startsWith("0")) {
                string2 = string2.substring(1);
            }
            this.tfIPFields_[i].setText(string2);
            n = n2 + 1;
            if (n >= string.length()) break;
        }
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < 4; ++i) {
            this.tfIPFields_[i].setEnabled(bl);
        }
    }

    public void requestFocus() {
        this.tfIPFields_[0].requestFocus();
    }

    public void getFields(int[] nArray) {
        if (nArray != null && nArray.length >= 4) {
            for (int i = 0; i < 4; ++i) {
                String string = this.tfIPFields_[i].getText();
                nArray[i] = string.length() > 0 ? Integer.parseInt(string) : 0;
            }
        }
    }

    private static boolean isIPStrDivValid(String string) {
        boolean bl = false;
        if (string != null && string.length() <= 3) {
            bl = true;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static String formatIPStr(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            String string3;
            n2 = string.indexOf(46, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if ((string3 = string.substring(n, n2)) != null && !string3.equals("") && string3.length() <= 3) {
                for (int j = string3.length(); j < 3; ++j) {
                    string3 = "0" + string3;
                }
            } else {
                string3 = "000";
            }
            if (!IPAddrEditPanel.isIPStrDivValid(string3)) {
                string3 = "000";
            }
            string2 = string2 + string3;
            if (i < 3) {
                string2 = string2 + ".";
            }
            if ((n = n2 + 1) >= string.length()) break;
        }
        if (string2.length() != EMPTY_IP.length()) {
            string2 = EMPTY_IP;
        }
        return string2;
    }
}

